package ch.frankel.blog.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;

/**
 * Test {@link List} proxy that ignores calls to <code>add</code> and
 * <code>addAll</code> methods.
 * 
 * @author Nicolas Frankel
 */
public class NoOpAddInvocationHandler implements InvocationHandler {

    /** Proxied object. */
    private final List proxied;

    /**
     * Constructor.
     * 
     * @param proxied
     *            Proxied object
     */
    public NoOpAddInvocationHandler(List proxied) {

        this.proxied = proxied;
    }

    /**
     * Ignores methods that elements, else do what is expected.
     * 
     * @see java.lang.reflect.InvocationHandler#invoke(Object, Method, Object[])
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {

        if (method.getName().startsWith("add")) {

            return false;
        }

        return method.invoke(proxied, args);
    }
}
